local function inputs(event)
	--Check if player clicked screen, then skip to next screen if they did.
	local pn= event.PlayerNumber
	local button = event.button
	-- If the PlayerNumber isn't set, the button isn't mapped.  Ignore it.
	-- ...Unless it's the mouse.
	if not pn and event.DeviceInput.is_mouse == false then return end
	if event.DeviceInput.is_mouse then
		button = ToEnumShortString(event.DeviceInput.button)
	end
	if button == "Start" or button == "Back" then
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
	else
		--SCREENMAN:SystemMessage(button)
	end;
end;

return Def.ActorFrame{
	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback(inputs);
	end;

	LoadActor(THEME:GetPathG("","MBAA_OP"))..{
		InitCommand=cmd(Center;scaletofit,0,0,SCREEN_RIGHT,SCREEN_BOTTOM);
		OnCommand=cmd(sleep,65;queuecommand,"NextScreen");
		--[[CodeMessageCommand=function(self, param)
			self:playcommand("NextScreen")
		end;]]
		
		NextScreenCommand=function(self)
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
		end;
	};
	
	LoadFont("System")..{
		Text=THEME:GetString("Common","PressStart");
		InitCommand=cmd(zoom,1.5;vertalign,top;xy,SCREEN_CENTER_X/2,5;shadowcolor,color("#061CE8");shadowlengthy,3);
	};
	
	LoadFont("System")..{
		Text=THEME:GetString("Common","PressStart");
		InitCommand=cmd(zoom,1.5;vertalign,top;xy,SCREEN_WIDTH*.75,5;shadowcolor,color("#061CE8");shadowlengthy,3);
	};

};